
package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.dto.MyLinksDTO;
import gov.va.med.mhv.usermgmt.enumeration.LinkStatusEnumeration;
import gov.va.med.mhv.usermgmt.service.MyLinksService;
import gov.va.med.mhv.usermgmt.web.exception.MHVRuntimeException;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import javax.annotation.Resource;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class MyLinksController extends AbstractController {

	private static final long serialVersionUID = 5010579180069981061L;

	private static Logger log = LogManager.getLogger(MyLinksController.class);

	private DataTable myLinksTable = new DataTable();
	private DataTable editMyLinksTable = new DataTable();

	private MyLinksDTO selectedMyLink;
	private MyLinksDTO newMyLink = new MyLinksDTO(); 
	
	protected static final String MY_LINKS_SUMMARY_PAGE = "myLinksSummary";
	protected static final String MY_LINKS_DETAIL_PAGE = "myLinksDetail";
	protected static final String MY_LINKS_ADD_PAGE = "addMyLinks";
	protected static final String MY_LINKS_EDIT_PAGE = "editMyLinks";
	protected static final String MY_LINKS_DELETE_PAGE = "deleteMyLinks";
	protected static final String MY_LINKS_ADD_NEW_PAGE = "saveAndNewMyLinks";
	
	protected String myLinksReturnPage;

	@Resource(name = "myLinksServiceProxy")
	private MyLinksService myLinksService;
	
	private List <MyLinksDTO> myLinks = new ArrayList<MyLinksDTO>();
	private List <MyLinksDTO> editMyLinks = new ArrayList<MyLinksDTO>();
	private List <MyLinksDTO> activeMyLinks = new ArrayList<MyLinksDTO>();
	
	private String now = null;
	
	private Boolean displayNameRequired=false;
	private Boolean displayLinkRequired=false;
	private Boolean displayLinkInvalid=false;
	
	protected ValueExpression sortEditColumn;
	protected String sortEditBy;



	
	public void authorize(ComponentSystemEvent event) throws IOException{
	
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		FacesContext context =FacesContext.getCurrentInstance();
		if(request.getUserPrincipal() == null){
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "uanuthorized.xhtml");
		}
		
		myLinksTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("addMyLinksForm:myLinkListAdd");
		editMyLinksTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("editMyLinksForm:myLinkListEdit");

		newMyLink.setLink("http://");
		if (!FacesContext.getCurrentInstance().isPostback()) {
		    loadMyLinks();	
		}
		if(sortColumn != null && sortBy != null){
			myLinksTable.setValueExpression("sortBy", sortColumn);
			myLinksTable.setSortOrder(sortBy);
		} 
	}
	
	
	public void editInit(ComponentSystemEvent event) throws IOException{
		
		if(sortEditColumn != null && sortEditBy != null){
			editMyLinksTable.setValueExpression("sortBy", sortColumn);
			editMyLinksTable.setSortOrder(sortBy);
		} 
	}


	
	public String showMyLinkDetails(){
		try {
			myLinksReturnPage = MY_LINKS_DETAIL_PAGE;
			selectedMyLink = (MyLinksDTO) myLinksTable.getRowData();
		} catch (Exception e) {
			log.error("Error in showMyLinkDetails", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MY_LINKS_DETAIL_PAGE;
	}
	
	protected List<MyLinksDTO> loadMyLinks() {
		
		myLinks = new ArrayList<MyLinksDTO>();
		editMyLinks = new ArrayList<MyLinksDTO>();
		activeMyLinks = new ArrayList<MyLinksDTO>();
		
		UserProfileDTO userProfile = null;
		Date newDate=new Date();
		DateFormat dtfmt = new SimpleDateFormat( "MM/dd/yyyy");
		dtfmt.setTimeZone(TimeZone.getTimeZone("America/New_York"));
		
        DateFormat dtfmt2 = new SimpleDateFormat("HH:mm");
		dtfmt2.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        
		now=dtfmt.format(newDate);
		now+=" at ";
		now+=dtfmt2.format(newDate);
		
		userProfile = getCurrentUserProfile(getUserScreenName());
		
		setFirstName(userProfile.getName().getFirstName());
		setLastName(userProfile.getName().getLastName());
		
		try {
	
			
			if (null != userProfile && null != userProfile.getId()) {
				myLinks = getMyLinksService().getMyLinksByUserId(userProfile.getId());
				//myLinksTable.setRows(10);
				//myLinksTable.setFirst(0);
			} else {
				log.error("userProfile is null");
				throw new MHVRuntimeException("userProfile is null");
			}
		} catch(Exception e) {
			log.error("Error in loading my links" + e);
		}
		
		
		if (myLinks!=null) {
			for (MyLinksDTO dto: myLinks) {
				if (dto.getStatus().equalsIgnoreCase("A")) {
					activeMyLinks.add(dto);
				}
			}
		}
		setEditMyLinks(myLinks);
		return myLinks;
	}
	
	public String loadAddNewMyLink() {
		try{
			
			newMyLink = new MyLinksDTO();
			
			initializeMyLink(newMyLink);
			
			// which page to return from edit page 'Cancel' button
			myLinksReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("myLinksReturnPage");
			
		} catch (Exception e) {
			log.error("Error in loadAddNewMyLink", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MY_LINKS_ADD_PAGE;    
	}
	
	public String reset() {
		resetInputValidationErrors();

		try{
			resetMessages();
			
			newMyLink = new MyLinksDTO();
			
			initializeMyLink(newMyLink);
			
			// which page to return from edit page 'Cancel' button
			myLinksReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("myLinksReturnPage");
			
		} catch (Exception e) {
			log.error("Error in loadAddNewMyLink", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MY_LINKS_ADD_PAGE;    
	}
	
	
	public String loadEditMyLinkFromAdd(MyLinksDTO myLinksDto) {
		try{
			selectedMyLink = myLinksDto;
			
			resetMessages();
			
			// which page to return from edit page 'Cancel' button
			myLinksReturnPage = MY_LINKS_ADD_PAGE;
		} catch (Exception e) {
			log.error("Error in loadEditMyLinksFromAdd", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MY_LINKS_EDIT_PAGE;
	}
	
	
	public String loadEditMyLinkFromEdit(MyLinksDTO myLinksDto) {
		try{
			selectedMyLink = myLinksDto;
			
			resetMessages();
			
			// which page to return from edit page 'Cancel' button
			myLinksReturnPage = MY_LINKS_EDIT_PAGE;
		} catch (Exception e) {
			log.error("Error in loadEditMyLinksFromEdit", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MY_LINKS_EDIT_PAGE;
	}
	

	public String loadEditMyLinksFromDetail() {
		try{
			// which page to return from edit page 'Cancel' button
			myLinksReturnPage = MY_LINKS_DETAIL_PAGE;
		} catch (Exception e) {
			log.error("Error in loadEditMedicationFromDetail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MY_LINKS_EDIT_PAGE;
	}
	
	public String loadEditMyLinks() {
		try{
			String strmyLinkId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("myLinkId");
			Long myLinkId = Long.valueOf(strmyLinkId);
			
			selectedMyLink = loadMyLink(myLinkId);
		} catch (Exception e) {
			log.error("Error in loadEditMyLinks", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MY_LINKS_EDIT_PAGE;
	}

	public String loadDeleteMyLink(MyLinksDTO myLinksDto) {
		try{
			resetMessages();
			
			// which page to return from edit page 'Cancel' button
			myLinksReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("myLinksReturnPage");
			selectedMyLink = myLinksDto;
		} catch (Exception e) {
			log.error("Error in loadDeleteMyLink", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MY_LINKS_DELETE_PAGE;
	}
	
	public String returnToCallingPage() {
		resetMessages();
		myLinksReturnPage = (null != myLinksReturnPage && myLinksReturnPage.trim().length() > 0) ? myLinksReturnPage : MY_LINKS_SUMMARY_PAGE;

		return myLinksReturnPage;
	}
	
	
	public String returnToSummaryPage(){
		resetMessages();
		return MY_LINKS_SUMMARY_PAGE;
	}
	
	public String returnToAddlinksPage(){
		resetMessages();
		return MY_LINKS_ADD_PAGE;
	}
	
	public String saveMyLink() {
		log.info("===============inside saveMyLink()==========");
		
		ResponseUtil response = null;
		String returnpage = MY_LINKS_ADD_PAGE;
		String requestFrom = null;
		MyLinksDTO saveMyLink = new MyLinksDTO();
		
		
		try {
			requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");
			
			if (null != requestFrom) {
				if (requestFrom.equalsIgnoreCase(MY_LINKS_ADD_PAGE) 
						|| requestFrom.equalsIgnoreCase(MY_LINKS_ADD_NEW_PAGE)) {
					saveMyLink = newMyLink;
					returnpage = MY_LINKS_ADD_PAGE;
					
				} else if (requestFrom.equalsIgnoreCase(MY_LINKS_EDIT_PAGE)) {
					saveMyLink = selectedMyLink;
					returnpage = MY_LINKS_EDIT_PAGE;
				}
			}
			
			
		inputValidations(saveMyLink);

		response = getMyLinksService().saveMyLink(saveMyLink);

			// response has errors
			if (response.isFailure()) {
				log.info("isFailure : " + response.isFailure());
				super.processErrorMessages(response);
				resetMessages();
			} else if (response.isSuccess()) {
				if (requestFrom.equalsIgnoreCase(MY_LINKS_ADD_NEW_PAGE)) {
					saveAddNewMessage=true;
					addNewMessage = false;
					return loadAddNewMyLink();
				} else if (requestFrom.equalsIgnoreCase(MY_LINKS_EDIT_PAGE)) {
					saveMessage = true;
				} else if (requestFrom.equalsIgnoreCase(MY_LINKS_ADD_PAGE)) {
					addNewMessage = true;
					saveAddNewMessage=false;

				}
				
			}
		} catch (Exception e) {
			log.error("Error in saving new my link", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		} 
		
		loadMyLinks();
		return returnpage;
	}


	private void inputValidations(MyLinksDTO saveMyLink) {
		resetInputValidationErrors();
		
		if(saveMyLink.getDisplayName().trim().isEmpty() || saveMyLink.getDisplayName()==null) {
			setDisplayNameRequired(true);
		}
		else {
			setDisplayNameRequired(false);

		}

		if(saveMyLink.getLink().trim().isEmpty() || saveMyLink.getLink()==null) {
			setDisplayLinkRequired(true);
		}
		else {
			setDisplayLinkRequired(false);

		}
		
		if(!saveMyLink.getDisplayName().trim().isEmpty() && saveMyLink.getDisplayName()!=null) {
			String linkName=saveMyLink.getLink().trim();
	
			int linkSize="http://".length();
			
			if(linkName!=null && (linkName.contains("http://") && !(linkName.length() > linkSize)) ) {
				setDisplayLinkInvalid(true);
			}		
			else {
				setDisplayLinkInvalid(false);

			}
			
		}
	
	}

	public String saveMyLinkLoadAddNewMyLink() {
		addNewMessage = true;
		return MY_LINKS_ADD_PAGE;
	}
	
	public String deleteMyLink() {
		log.info("===============inside deleteMyLink()==========");
		
		ResponseUtil response = null;
		
		try {
			String strmyLinkId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("myLinkId");
			Long myLinkId = Long.valueOf(strmyLinkId);
			
			response = getMyLinksService().deleteMyLink(myLinkId);
			
			// response has errors
			if (response.isFailure()) {
				log.info("isFailure : " + response.isFailure());
				super.processErrorMessages(response);
			} else {
				deleteMessage = true;
			}
		} catch (Exception e) {
			log.error("Error in deleting my link", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		loadMyLinks();
		return MY_LINKS_ADD_PAGE;
	}
	
	private MyLinksDTO loadMyLink(Long myLinkId) {
		MyLinksDTO myLink = null;
		
		try {
			myLink = getMyLinksService().getMyLinksById(myLinkId);
		} catch(Exception e) {
			log.error("Error in loading loadMyLink" + e);
			throw new MHVRuntimeException("Error in loading loadMyLink", e);
		}
		
		return myLink;
	}
	
	private void initializeMyLink(MyLinksDTO myLink) {
		myLink.setId(null);
		myLink.setDisplayName(null);
		myLink.setLink(null);
		myLink.setStatus(null);
		myLink.setOplock(0);
		myLink.setUserProfileId(getUserProfileId());
	}
	
	public void setMyLinksTable(DataTable myLinksTable) {
		this.myLinksTable = myLinksTable;
	}
	
	public DataTable getMyLinksTable() {
		return myLinksTable;
	}


	public DataTable getEditMyLinksTable() {
		return editMyLinksTable;
	}


	public void setEditMyLinksTable(DataTable editMyLinksTable) {
		this.editMyLinksTable = editMyLinksTable;
	}


	public MyLinksDTO getSelectedMyLink() {
		return selectedMyLink;
	}

	public void setSelectedMyLink(MyLinksDTO selectedMyLink) {
		this.selectedMyLink = selectedMyLink;
	}

	public MyLinksDTO getNewMyLink() {
		return newMyLink;
	}

	public void setNewMyLink(MyLinksDTO newMyLink) {
		this.newMyLink = newMyLink;
	}

	public MyLinksService getMyLinksService() {
		return myLinksService;
	}

	public void setMyLinksService(MyLinksService myLinksService) {
		this.myLinksService = myLinksService;
	}

	public List<MyLinksDTO> getMyLinks() {
		return myLinks;
	}

	public void setMyLinks(List<MyLinksDTO> myLinks) {
		this.myLinks = myLinks;
	}


	public String getNow() {
		return now;
	}

	public void setNow(String now) {
		this.now = now;
	}
	
	public LinkStatusEnumeration[] getLinkStatuses() {
		return LinkStatusEnumeration.values();
	}


	public List<MyLinksDTO> getActiveMyLinks() {
		return activeMyLinks;
	}


	public void setActiveMyLinks(List<MyLinksDTO> activeMyLinks) {
		this.activeMyLinks = activeMyLinks;
	}
	
	public List<MyLinksDTO> getEditMyLinks() {
		return editMyLinks;
	}


	public void setEditMyLinks(List<MyLinksDTO> editMyLinks) {
		this.editMyLinks = editMyLinks;
	}


	public String validateLink (MyLinksDTO mylinksDto) {
		selectedMyLink=mylinksDto;
		if (selectedMyLink!=null) {
			String link=selectedMyLink.getLink();
			if(link.startsWith("http://")) {
				ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
				 try {
					externalContext.redirect(link);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
		return "error";
	}
	
	protected void saveSortInfo() {
		editMyLinksTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("editMyLinksForm:myLinkListEdit");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if(sortColumn != null && sortBy != null){
				editMyLinksTable.setValueExpression("sortBy", sortColumn);
				editMyLinksTable.setSortOrder(sortBy);
				
			} 
		}
		
		myLinksTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("addMyLinksForm:myLinkListAdd");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if(sortColumn != null && sortBy != null){
				myLinksTable.setValueExpression("sortBy", sortColumn);
				myLinksTable.setSortOrder(sortBy);
				
			} 
		}

		
	}	
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}
	
	
	public void onEditSort(SortEvent event){
		sortEditColumn=event.getSortColumn().getValueExpression("sortBy");
		sortEditBy=event.isAscending()?"ascending":"descending";
	}




	public Boolean getDisplayNameRequired() {
		return displayNameRequired;
	}


	public void setDisplayNameRequired(Boolean displayNameRequired) {
		this.displayNameRequired = displayNameRequired;
	}


	public Boolean getDisplayLinkRequired() {
		return displayLinkRequired;
	}


	public void setDisplayLinkRequired(Boolean displayLinkRequired) {
		this.displayLinkRequired = displayLinkRequired;
	}


	public Boolean getDisplayLinkInvalid() {
		return displayLinkInvalid;
	}


	public void setDisplayLinkInvalid(Boolean displayLinkInvalid) {
		this.displayLinkInvalid = displayLinkInvalid;
	}
	
	public void resetInputValidationErrors() {
		displayNameRequired=false;
		displayLinkRequired=false;
		displayLinkInvalid=false;


	}


	public ValueExpression getSortEditColumn() {
		return sortEditColumn;
	}


	public void setSortEditColumn(ValueExpression sortEditColumn) {
		this.sortEditColumn = sortEditColumn;
	}


	public String getSortEditBy() {
		return sortEditBy;
	}


	public void setSortEditBy(String sortEditBy) {
		this.sortEditBy = sortEditBy;
	}
	
}
